<?php

namespace backend\controllers;

use Yii;
use backend\models\Calificacion;
use backend\models\Calificacioncalificaciones;
use backend\models\Calificacionfrd;
use backend\models\Calificacionobservacionesgenerales;
use backend\models\Seleccionmultiple;
use backend\models\Periodo;
use backend\models\Academico;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Tercero;
use backend\models\Competencia;
use backend\models\CalificacionSearch;
use backend\models\Frd;
use backend\models\Desempeno;
use backend\models\Promedio;
use backend\models\Promedioarea;

use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\data\ActiveDataProvider;
use yii\base\Model;
use yii\helpers\Html;
use yii\web\Response;
use yii\widgets\ActiveForm;




/**
 * CalificacionController implements the CRUD actions for Calificacion model.
 */
class CalificacionController extends Controller
{
    public $actions;

    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }

    /**
     * Lists all Calificacion models.
     * @return mixed
     */
    public function actionIndex()
    {
        return $this->redirect(['docente/index']);
    }

    public function actionCalificaciones()
    {
        $periodo = new Periodo();
        $grupo = Grupo::find()->where(['id' => Yii::$app->request->get('grupo')])->one();
        $asignatura = Asignatura::find()->where(['id' => Yii::$app->request->get('asignatura')])->one(); 
        $psi = $grupo->sedes->psi;
        $entrada = $grupo->sedes->entrada;
        $fallas = $grupo->sedes->fallas;
        $definitiva_psi = 0;

        //$actual = $periodo->actual->id;

        //$actual = $periodo->autorizadoporfecha;


        //echo "Periodo: ".$actual->periodo;
        
        /*

        if(isset($actual))
        {
            if($actual->autorizar_calificaciones != '1')
            {
                throw new NotFoundHttpException('<b>Las calificaciones están inactivas por el momento</b>.');
            }

            
            
            //throw new NotFoundHttpException('<b>El '.$actual->periodo.' de publicar las calificaciones ha caducado</b>. Estuvíeron activas desde el '. Yii::$app->formatter->asDatetime($actual->calificaciones_inicio,'full') .' hasta '. Yii::$app->formatter->asDatetime($actual->calificaciones_fin,'full'));
        }
        else
        {
            throw new NotFoundHttpException('Las calificaciones están inactivas por el momento.');   
        }
        */

        if($grupo->sedes->autorizar_calificaciones == 0) {
            throw new NotFoundHttpException('Las calificaciones están inactivas por la sede en este momento.');
        }

        if($asignatura->especialidad == 1)
        {
            $query = Academico::find()->select(['tercero.id', 'academico.estudiante', 'academico.grupo'])->joinWith(['estudiantes'])->where(['<', 'tercero.estado', 3])->andWhere(['academico.grupo' => Yii::$app->request->get('grupo')])->orderBy('primer_apellido');  
        }
        else
        {
            $query = Academico::find()->select(['tercero.id', 'academico.estudiante', 'academico.grupo'])->joinWith(['estudiantes'])->where(['<', 'tercero.estado', 3])->andWhere(['academico.grupo' => Yii::$app->request->get('grupo')])->andWhere(['academico.especialidad' => $asignatura->especialidad])->orderBy('primer_apellido');     
        }    
        

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'pageSize' => 500,
            ],
        ]);
        

        $registros = Calificacion::find()->where(['grupo' => Yii::$app->request->get('grupo')])->andWhere(['asignatura' => Yii::$app->request->get('asignatura'), 'periodo' => $periodo->actual->id])->count();

        $count = count(Yii::$app->request->post('Calificacion', []));
        
        
        $tipo_calificacion = $grupo->grados->tipo_calificacion;
        $calificacionxcompetencia = $grupo->grados->calificacionxcompetencia;
        
        $frd_sede = $grupo->sedes->frd;

        $num_competencias = Competencia::find()->where(['asignatura' => Yii::$app->request->get('asignatura')])->andWhere(['periodo' => $periodo->actual->id])->count(); 

        $num_calificaciones_saber = $calificacionxcompetencia == 1 ? $asignatura->num_calificaciones_saber : $num_competencias;
        $num_calificaciones_ser = $asignatura->num_calificaciones_ser;
        $por_calificaciones_saber = $asignatura->por_calificaciones_saber;
        $por_calificaciones_ser = $asignatura->por_calificaciones_ser; 
        $por_calificaciones_psi = $asignatura->por_calificaciones_psi; 
        $num_calificaciones_psi = $grupo->sedes->num_calificaciones_psi;

        $competencias = [];

        if($periodo->actual->id != '5')
        {
            if ($num_competencias == 0)
            {
                $error =  '<b>No hay competencias cargadas en la asignatura para el '.$periodo->actual->periodo.'</b>, debes cargar las competencias primero para poder realizar el cargue de las calificaciones. ';
                $error .= Html::a('<i class="far fa-plus" aria-hidden="true"></i> Agregar Competencias', ['competencia/create', 'grado' => $grupo->grados->id, 'asignatura' => Yii::$app->request->get('asignatura')],['class' => 'btn btn-block btn-success', 'style' => 'margin-top: 20px;']);

                throw new NotFoundHttpException($error);
            } 
            else
            {
                $competencias = Competencia::find()->where(['asignatura' => Yii::$app->request->get('asignatura')])->andWhere(['periodo' => $periodo->actual->id])->all(); 
            }   
        }
        

        $calificaciones = [new Calificacion()]; 

        $seleccionmultiple = new Seleccionmultiple();


        for($i = 1; $i < $count; $i++) {

            $calificaciones[] = new Calificacion();
        }

        if (Yii::$app->request->isAjax && Model::loadMultiple($calificaciones, Yii::$app->request->post())) {
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ActiveForm::validateMultiple($calificaciones);
        }

        elseif (Model::loadMultiple($calificaciones, Yii::$app->request->post())) 
            //&& Model::validateMultiple($calificaciones))  // LA VALIDACION EN EL CONTROLLER DE CALIFICACION Y COEVALUACION GENERA CONFLICTO, SOLO EN LA VISTA LA VALIDACION   
        {

            foreach ($calificaciones as $calificacion) 
            {
                $reg = Calificacion::find()->select(['id'])->where(['estudiante' => $calificacion->estudiante])->andWhere(['grupo' => $calificacion->grupo, 'asignatura' => $calificacion->asignatura, 'periodo' => $periodo->actual->id])->one();
                
                $estudiante = Tercero::find()->where(['id' => $calificacion->estudiante])->one();

                $count_reg = Calificacion::find()->select(['id'])->where(['estudiante' => $calificacion->estudiante])->andWhere(['grupo' => $calificacion->grupo, 'asignatura' => $calificacion->asignatura, 'periodo' => $periodo->actual->id])->count();

                if(!isset($reg))  /// NUEVO REGISTRO
                {                       
                    $model= new Calificacion;
                    
                        if ($calificacionxcompetencia == 1) // POR ASIGNATURA
                        {
                            $model->saber = $calificacion->saber;
                            $model->promedio_saber = $calificacion->saber;
                            $model->definitiva_saber = $calificacion->saber;


                            if($num_calificaciones_ser > 0)
                            {
                                $model->ser = $calificacion->ser;
                                $model->promedio_ser = $calificacion->ser;
                                $model->definitiva_ser = $calificacion->ser;
                                $model->definitiva_periodo = $calificacion->definitiva_periodo;    
                            }
                            else
                            {
                                $model->definitiva_periodo = $calificacion->saber;    
                            }
                            

                            if($psi == 1)
                            {
                                $model->psi = $calificacion->psi;
                                $model->promedio_psi = $calificacion->psi;
                                $model->definitiva_psi = $calificacion->psi;
                                $model->definitiva_periodo = $calificacion->definitiva_periodo;
                            }

                            if($model->nivelacion == NULL)
                            {
                                $model->definitiva_final_periodo = $model->definitiva_periodo;
                            }
                            else
                            {
                                $model->definitiva_final_periodo = $model->nivelacion;
                            }    
                        }
                        else // POR COMPETENCIA
                        {

                            if($num_competencias > 0)
                            {
                                $model->saber = implode(",", $calificacion->saber);
                                $model->promedio_saber = $model->promedio($calificacion->saber, $num_competencias);
                                $model->definitiva_saber = $model->definitiva($calificacion->saber, $num_competencias, $por_calificaciones_saber);
                                
                            }
                            

                            if($num_calificaciones_ser > 0)
                            {
                                $model->ser = implode(",", $calificacion->ser);    
                                $model->promedio_ser = $model->promedio($calificacion->ser, $num_calificaciones_ser);
                                $model->definitiva_ser = $model->definitiva($calificacion->ser, $num_calificaciones_ser, $por_calificaciones_ser);
                            }    
                            
                            
                            if($psi == 1)
                            {
                                $model->psi = implode(",", $calificacion->psi);
                                $definitiva_psi = $model->definitiva($calificacion->psi, 1, $por_calificaciones_psi);
                            }

                            if($tipo_calificacion != 1)
                            {
                                $model->definitiva_periodo = $model->definitiva_saber + $model->definitiva_ser + $definitiva_psi;

                                if($model->nivelacion == NULL)
                                {
                                    $model->definitiva_final_periodo = $model->definitiva_periodo;

                                }
                                else
                                {
                                    $model->definitiva_final_periodo = $model->nivelacion;
                                }                                
                            }    
                        }

                    $model->docente = $calificacion->docente;
                    $model->estudiante = $calificacion->estudiante;
                    $model->asignatura = $calificacion->asignatura;
                    $model->grupo = $calificacion->grupo;
                    $model->periodo = $calificacion->periodo;
                    
                    if($frd_sede == 0)
                    {
                        $model->frd = implode(",", $calificacion->frd);    
                    }    
                    
                    $model->observacion_general = $calificacion->observacion_general;
                    $model->observacion_especifica = $calificacion->observacion_especifica;

                    
                    if($fallas == 0)
                    {
                        $model->fallas = $calificacion->fallas;    
                    }    
                    
                    $transaction = Yii::$app->db->beginTransaction();

                    try  {
                        if ($model->save(false)) {
                            

                            if($num_calificaciones_saber > 0 or $num_competencias > 0)
                            {
                                if ($calificacionxcompetencia == 1) // POR ASIGNATURA
                                {
                                    $calificacion->saber = explode(",",$calificacion->saber);
                                }

                                $i = 1;
                                foreach ($calificacion->saber as $c_saber) {
                                    $saber = new Calificacioncalificaciones();
                                    $saber->tipo = 'saber';
                                    $saber->calificacion_id = $model->id;

                                    if($tipo_calificacion == 1)
                                    {
                                        $total = Desempeno::find()->where(['nota' => $c_saber])
                                                ->andWhere(['tipo_calificacion' => $tipo_calificacion])
                                                ->count();
                                
                                        if($total > 0)
                                        {
                                            $saber->calificacion = $c_saber;
                                        }    
                                        else
                                        {
                                            if($c_saber != '')
                                            {

                                                Yii::$app->session->addFlash('mensaje', [
                                                    'tipo' => 'danger',
                                                    'titulo' => 'Error en la Nota',
                                                    'icono' => 'far info',
                                                    'mensaje' => 'La Nota <b>('.$c_saber.')</b> del estudiante <b>'.$estudiante->nombre.'</b> no exite.',
                                                ]);    
                                            }
                                        }
                                    }
                                    else
                                    {
                                        $saber->calificacion = $c_saber;
                                    }    
                                    

                                    $saber->docente = $model->docente;
                                    $saber->estudiante = $model->estudiante;
                                    $saber->grupo = $model->grupo;
                                    $saber->asignatura = $model->asignatura;
                                    $saber->periodo = $model->periodo;
                                    $saber->competencia = $calificacion->competencia[$i];
                                    $saber->save();

                                    //var_dump($saber->errors);

                                    $i++;

                                }

                                
                                $i = 1;
                                foreach ($calificacion->frd as $c_frd) {
                                    
                                    Calificacionfrd::deleteAll(['calificacion' => $model->id, 'docente' => $calificacion->docente, 'estudiante' => $calificacion->estudiante, 'grupo' => $calificacion->grupo, 'asignatura' => $calificacion->asignatura, 'periodo' => $calificacion->periodo, 'competencia' => $calificacion->competencia[$i]]);

                                    $registros = explode(",", $c_frd);

                                    foreach ($registros as $registro) {
                                        
                                        $total = Frd::find()->where(['id' => $registro])->andWhere(['competencia' => $calificacion->competencia[$i]])->count();    
                                        

                                        if($total > 0)
                                        {

                                            $frd = new Calificacionfrd();
                                            $frd->calificacion = $model->id;
                                            $frd->frd = $registro;
                                            $frd->docente = $model->docente;
                                            $frd->estudiante = $model->estudiante;
                                            $frd->grupo = $model->grupo;
                                            $frd->asignatura = $model->asignatura;
                                            $frd->periodo = $model->periodo;
                                            $frd->competencia = $calificacion->competencia[$i];
                                            
                                            $frd->save(false);
                                            
                                        }
                                        else
                                        {
                                            if($registro != '')
                                            {
                                                Yii::$app->session->addFlash('mensaje'.$model->id, [
                                                    'tipo' => 'danger',
                                                    'titulo' => 'FRD Error',
                                                    'icono' => 'far info',
                                                    'mensaje' => 'El código de FRD <b>('.$registro.')</b> no existe o no corrresponde a la competencia del estudiante <b>'.$estudiante->nombre.'</b>.',
                                                ]);       
                                            }    
                                            
                                        }    
                                            
                                        
                                    }

                                    $i++;

                                }
                            }

                            /////////////     CALIFICACIONES DEL SER   ///////////////////

                            if($num_calificaciones_ser > 0)
                            {
                                if ($calificacionxcompetencia == 1) // POR ASIGNATURA
                                {
                                    $calificacion->ser = explode(",",$calificacion->ser);
                                }

                                $i = 1;
                                foreach ($calificacion->ser as $c_ser) {
                                    
                                    $ser = new Calificacioncalificaciones();
                                    $ser->tipo = 'ser';
                                    $ser->calificacion_id = $model->id;
                                    $ser->calificacion_numero = $i;

                                    if($tipo_calificacion == 1)
                                    {
                                        $total = Desempeno::find()->where(['nota' => $c_ser])
                                                ->andWhere(['tipo_calificacion' => $tipo_calificacion])
                                                ->count();
                                
                                        if($total > 0)
                                        {
                                            $ser->calificacion = $c_ser;
                                        }    
                                        else
                                        {
                                            if($c_ser != '')
                                            {

                                                Yii::$app->session->addFlash('mensaje', [
                                                    'tipo' => 'danger',
                                                    'titulo' => 'Error en la Nota',
                                                    'icono' => 'far info',
                                                    'mensaje' => 'La Nota <b>('.$c_ser.')</b> del estudiante <b>'.$estudiante->nombre.'</b> no exite.',
                                                ]);    
                                            }
                                        }
                                    }
                                    else
                                    {
                                        $ser->calificacion = $c_ser;
                                    }    
                                    

                                    $ser->docente = $model->docente;
                                    $ser->estudiante = $model->estudiante;
                                    $ser->grupo = $model->grupo;
                                    $ser->asignatura = $model->asignatura;
                                    $ser->periodo = $model->periodo;
                                    $ser->save();

                                    $i++;

                                }
                            }

                            ///////////// FIN DE SER ///////////////////


                            /////////////     CALIFICACIONES PSI   ///////////////////

                            if($psi == 1)
                            {
                                if ($calificacionxcompetencia == 1) // POR ASIGNATURA
                                {
                                    $calificacion->psi = explode(",",$calificacion->psi);
                                }

                                $i = 1;
                                foreach ($calificacion->psi as $c_psi) {
                                        
                                    $r_psi = new Calificacioncalificaciones();
                                    $r_psi->tipo = 'psi';
                                    $r_psi->calificacion_id = $model->id;
                                    $r_psi->calificacion_numero = $i;

                                    if($tipo_calificacion == 1)
                                    {
                                        $total = Desempeno::find()->where(['nota' => $c_psi])
                                                ->andWhere(['tipo_calificacion' => $tipo_calificacion])
                                                ->count();
                                
                                        if($total > 0)
                                        {
                                            $r_psi->calificacion = $c_psi;
                                        }    
                                        else
                                        {
                                            if($c_psi != '')
                                            {

                                                Yii::$app->session->addFlash('mensaje', [
                                                    'tipo' => 'danger',
                                                    'titulo' => 'Error en la Nota',
                                                    'icono' => 'far info',
                                                    'mensaje' => 'La Nota <b>('.$c_psi.')</b> del estudiante <b>'.$estudiante->nombre.'</b> no exite.',
                                                ]);    
                                            }
                                        }
                                    }
                                    else
                                    {
                                        $r_psi->calificacion = $c_psi;
                                    }    
                                    

                                    $r_psi->docente = $model->docente;
                                    $r_psi->estudiante = $model->estudiante;
                                    $r_psi->grupo = $model->grupo;
                                    $r_psi->asignatura = $model->asignatura;
                                    $r_psi->periodo = $model->periodo;
                                    $r_psi->save();

                                    $i++;

                                }
                            
                            }

                            ///////////// FIN DE PSI ///////////////////

                            $transaction->commit();

                            Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'success',
                                'titulo' => 'Calificaciones Almacenadas',
                                'icono' => 'fa fa-check-square-o',
                                'mensaje' => 'Las calificaciones de <b>'.$estudiante->nombre.'</b> se almacenaron con éxito en el sistema',
                            ]);

                        } else {
                            $transaction->rollBack();

                            Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'danger',
                                'titulo' => 'Calificaciones No Almacenadas',
                                'icono' => 'fa fa-check-square-o',
                                'mensaje' => 'Las calificaciones de <b>'.$estudiante->nombre.'</b> no se almacenaron en el sistema',
                            ]);
                        }
                    } catch (Exception $e) {
                        $transaction->rollBack();
                    }
                }
                else //Actualizar Calificaciones 
                {  
                    $model = Calificacion::find()->where(['id' => $reg->id])->one();
                    
                    if ($calificacionxcompetencia == 1) // POR ASIGNATURA
                    {
                        if($num_calificaciones_saber > 0)
                        {
                            if($num_calificaciones_saber = 1)
                            {
                                $model->saber = $calificacion->saber;    
                            }
                            else
                            {
                                $model->saber = implode(",", $calificacion->saber);
                            }
                            
                        }

                        if($num_calificaciones_ser > 0)
                        {
                            $model->ser = implode(",", $calificacion->ser);
                        }

                        if($psi == 1)
                        {
                            $model->psi = implode(",", $calificacion->psi);
                            $definitiva_psi = $model->definitiva($calificacion->psi, 1, $por_calificaciones_psi);
                        }

                        if($tipo_calificacion == 2) // TIPO CALIFICACION NUMEROS
                        {
                            if($num_calificaciones_saber > 0)
                            {
                                $model->promedio_saber = $model->promedio($calificacion->saber, $num_calificaciones_saber);
                                $model->definitiva_saber = $model->definitiva($calificacion->saber, $num_calificaciones_saber, $por_calificaciones_saber);
                            }

                            if($num_calificaciones_ser > 0)
                            {
                                $model->promedio_ser = $model->promedio($calificacion->ser, $num_calificaciones_ser);
                                $model->definitiva_ser = $model->definitiva($calificacion->ser, $num_calificaciones_ser, $por_calificaciones_ser);
                            }

                            $model->definitiva_periodo = $model->definitiva_saber + $model->definitiva_ser + $definitiva_psi;

                        }
                        else
                        {
                            if($num_calificaciones_saber = 1)
                            {
                                $model->definitiva_periodo = $calificacion->saber;   
                            }
                        }


                        if($model->nivelacion == NULL)
                        {
                            $model->definitiva_final_periodo = $model->definitiva_periodo;    
                        }
                        else
                        {
                            
                            $model->definitiva_final_periodo = $model->nivelacion;
                        }
                        
                    }
                    else // POR COMPETENCIA
                    {

                        //echo "<pre>";
                        //var_dump($calificacion);
                        //echo "</pre>";
                        
                        if($num_competencias > 0)
                        {
                            $model->saber = implode(",", $calificacion->saber);
                            $model->promedio_saber = $model->promedio($calificacion->saber, $num_competencias);
                            $model->definitiva_saber = $model->definitiva($calificacion->saber, $num_competencias, $por_calificaciones_saber);
                            
                        }
                        

                        if($num_calificaciones_ser > 0)
                        {
                            $model->ser = implode(",", $calificacion->ser);    
                            $model->promedio_ser = $model->promedio($calificacion->ser, $num_calificaciones_ser);
                            $model->definitiva_ser = $model->definitiva($calificacion->ser, $num_calificaciones_ser, $por_calificaciones_ser);
                        }    
                        
                        
                        if($psi == 1)
                        {
                            $model->psi = implode(",", $calificacion->psi);
                            $definitiva_psi = $model->definitiva($calificacion->psi, 1, $por_calificaciones_psi);
                        }

                        if ($periodo->actual->id != 5)
                        {
                            $model->definitiva_periodo = $model->definitiva_saber + $model->definitiva_ser + $definitiva_psi;    
                        }

                        if($tipo_calificacion != 1 && $periodo->actual->id != 5)
                        {
                            if($model->nivelacion == NULL)
                            {
                                $model->definitiva_final_periodo = $model->definitiva_periodo;    
                            }
                            else
                            {
                                $model->definitiva_final_periodo = $model->nivelacion;
                            }
                        }                                

                        ////// MODIFICACION DEL COMPUTO DE LOS 4 PERIODOS POR PARTE DEL DOCENTE

                        echo "<br>Tipo: ".$tipo_calificacion." - ".$periodo->actual->id;

                        if($tipo_calificacion != 1 && $periodo->actual->id == 5)
                        {
                            echo " => ".$calificacion->definitiva_final_periodo;
                            
                            $model->definitiva_final_periodo = $calificacion->definitiva_final_periodo;
                        }                                
                    }    
                    
                    //$model->docente = $calificacion->docente;
                    $model->estudiante = $calificacion->estudiante;
                    $model->asignatura = $calificacion->asignatura;
                    $model->grupo = $calificacion->grupo;
                    $model->periodo = $calificacion->periodo;
                    
                    if($frd_sede == 0 && $periodo->actual->id != 5)
                    {
                        $model->frd = implode(",", $calificacion->frd);    
                    }    
                    
                    

                    $model->observacion_general = $calificacion->observacion_general;
                    $model->observacion_especifica = $calificacion->observacion_especifica;

                    
                    if($fallas == 0)
                    {
                        $model->fallas = $calificacion->fallas;    
                    } 

                    $transaction = Yii::$app->db->beginTransaction();

                    try {
                            if ($model->update(false)) 
                            {
                                //echo "# ".$num_calificaciones_saber.' - '.$num_competencias;

                                if($num_calificaciones_saber > 0 or $num_competencias > 0)
                                {

                                    if($num_calificaciones_saber == 1)
                                    {
                                        $saber = Calificacioncalificaciones::find()
                                                    ->where(['calificacion_id' => $reg->id])
                                                    ->andWhere(['tipo' => 'saber'])
                                                    ->andWhere(['docente' => $calificacion->docente])
                                                    ->andWhere(['estudiante' => $calificacion->estudiante])
                                                    ->andWhere(['grupo' => $calificacion->grupo])
                                                    ->andWhere(['asignatura' => $calificacion->asignatura])
                                                    ->andWhere(['periodo' => $calificacion->periodo])
                                                    //->andWhere(['competencia' => $calificacion->competencia[$i]])
                                                    ->one();
                                            
                                                if(!isset($saber))
                                                {
                                                
                                                    $saber = new Calificacioncalificaciones();
                                                    $saber->calificacion_id = $reg->id;
                                                    $saber->tipo = 'saber';
                                                    $saber->docente = $calificacion->docente;
                                                    $saber->estudiante = $calificacion->estudiante;
                                                    $saber->grupo = $calificacion->grupo;
                                                    $saber->asignatura = $calificacion->asignatura;
                                                    $saber->periodo = $calificacion->periodo;
                                                    //$saber->competencia = $calificacion->competencia[$i];
                                                    $saber->save(false);

                                                    Yii::$app->session->addFlash('mensaje', [
                                                        'tipo' => 'success',
                                                        'titulo' => 'Calificaciones Almacenadas',
                                                        'icono' => 'fa fa-check-square-o',
                                                        'mensaje' => 'Las calificaciones de <b>'.$estudiante->nombre.'</b> se almacenaron con éxito en el sistema',
                                                    ]);

                                                    $saber = Calificacioncalificaciones::find()
                                                    ->where(['calificacion_id' => $reg->id])
                                                    ->andWhere(['tipo' => 'saber'])
                                                    ->andWhere(['docente' => $calificacion->docente])
                                                    ->andWhere(['estudiante' => $calificacion->estudiante])
                                                    ->andWhere(['grupo' => $calificacion->grupo])
                                                    ->andWhere(['asignatura' => $calificacion->asignatura])
                                                    ->andWhere(['periodo' => $calificacion->periodo])
                                                    //->andWhere(['competencia' => $calificacion->competencia[$i]])
                                                    ->one();

                                                }   

                                                if($tipo_calificacion == 1)
                                                {
                                                    $total = Desempeno::find()->where(['nota' => $calificacion->saber])
                                                            ->andWhere(['tipo_calificacion' => $tipo_calificacion])
                                                            ->count();
                                            
                                                    if($total > 0)
                                                    {
                                                        $saber->calificacion = $calificacion->saber;
                                                    }    
                                                    else
                                                    {
                                                        if($calificacion->saber != '')
                                                        {

                                                            Yii::$app->session->addFlash('mensaje', [
                                                                'tipo' => 'danger',
                                                                'titulo' => 'Error en la Nota',
                                                                'icono' => 'far info',
                                                                'mensaje' => 'La Nota <b>('.$c_saber.')</b> del estudiante <b>'.$estudiante->nombre.'</b> no exite.',
                                                            ]);    
                                                        }
                                                    }
                                                }
                                                else
                                                {
                                                    $saber->calificacion = $calificacion->saber;
                                                }
                                                

                                                $saber->update(false);
                                            $i++;


                                    }//////////////--------
                                    else // calificaciones saber mayor a 1, vector
                                    {

                                        $i = 1;
                                        
                                        foreach ($calificacion->saber as $c_saber) 
                                        {

                                                $saber = Calificacioncalificaciones::find()
                                                    ->where(['calificacion_id' => $reg->id])
                                                    ->andWhere(['tipo' => 'saber'])
                                                    ->andWhere(['docente' => $calificacion->docente])
                                                    ->andWhere(['estudiante' => $calificacion->estudiante])
                                                    ->andWhere(['grupo' => $calificacion->grupo])
                                                    ->andWhere(['asignatura' => $calificacion->asignatura])
                                                    ->andWhere(['periodo' => $calificacion->periodo])
                                                    ->andWhere(['competencia' => $calificacion->competencia[$i]])
                                                    ->one();
                                            
                                                if(!isset($saber))
                                                {
                                                
                                                    $saber = new Calificacioncalificaciones();
                                                    $saber->calificacion_id = $reg->id;
                                                    $saber->tipo = 'saber';
                                                    $saber->docente = $calificacion->docente;
                                                    $saber->estudiante = $calificacion->estudiante;
                                                    $saber->grupo = $calificacion->grupo;
                                                    $saber->asignatura = $calificacion->asignatura;
                                                    $saber->periodo = $calificacion->periodo;
                                                    $saber->competencia = $calificacion->competencia[$i];
                                                    $saber->save(false);

                                                    Yii::$app->session->addFlash('mensaje', [
                                                        'tipo' => 'success',
                                                        'titulo' => 'Calificaciones Almacenadas',
                                                        'icono' => 'fa fa-check-square-o',
                                                        'mensaje' => 'Las calificaciones de <b>'.$estudiante->nombre.'</b> se almacenaron con éxito en el sistema',
                                                    ]);

                                                    $saber = Calificacioncalificaciones::find()
                                                    ->where(['calificacion_id' => $reg->id])
                                                    ->andWhere(['tipo' => 'saber'])
                                                    ->andWhere(['docente' => $calificacion->docente])
                                                    ->andWhere(['estudiante' => $calificacion->estudiante])
                                                    ->andWhere(['grupo' => $calificacion->grupo])
                                                    ->andWhere(['asignatura' => $calificacion->asignatura])
                                                    ->andWhere(['periodo' => $calificacion->periodo])
                                                    ->andWhere(['competencia' => $calificacion->competencia[$i]])
                                                    ->one();

                                                }   

                                                if($tipo_calificacion == 1)
                                                {
                                                    $total = Desempeno::find()->where(['nota' => $c_saber])
                                                            ->andWhere(['tipo_calificacion' => $tipo_calificacion])
                                                            ->count();
                                            
                                                    if($total > 0)
                                                    {
                                                        $saber->calificacion = $c_saber;
                                                    }    
                                                    else
                                                    {
                                                        if($c_saber != '')
                                                        {

                                                            Yii::$app->session->addFlash('mensaje', [
                                                                'tipo' => 'danger',
                                                                'titulo' => 'Error en la Nota',
                                                                'icono' => 'far info',
                                                                'mensaje' => 'La Nota <b>('.$c_saber.')</b> del estudiante <b>'.$estudiante->nombre.'</b> no exite.',
                                                            ]);    
                                                        }
                                                    }
                                                }
                                                else
                                                {
                                                    $saber->calificacion = $c_saber;
                                                }
                                                

                                                $saber->update(false);
                                            $i++;
                                        }
                                    
                                        $i = 1;
                                        foreach ($calificacion->frd as $c_frd) 
                                        {
                                            
                                            Calificacionfrd::deleteAll(['calificacion' => $reg->id, 'docente' => $calificacion->docente, 'estudiante' => $calificacion->estudiante, 'grupo' => $calificacion->grupo, 'asignatura' => $calificacion->asignatura, 'periodo' => $calificacion->periodo, 'competencia' => $calificacion->competencia[$i]]);

                                            $registros = explode(",", $c_frd);

                                            foreach ($registros as $registro) {
                                                
                                                $total = Frd::find()->where(['id' => $registro])->andWhere(['competencia' => $calificacion->competencia[$i]])->count();    
                                                

                                                if($total > 0)
                                                {

                                                    $frd = new Calificacionfrd();
                                                    $frd->calificacion = $model->id;
                                                    $frd->frd = $registro;
                                                    $frd->docente = $model->docente;
                                                    $frd->estudiante = $model->estudiante;
                                                    $frd->grupo = $model->grupo;
                                                    $frd->asignatura = $model->asignatura;
                                                    $frd->periodo = $model->periodo;
                                                    $frd->competencia = $calificacion->competencia[$i];
                                                    
                                                    $frd->save(false);
                                                    
                                                }
                                                else
                                                {
                                                    if($registro != '')
                                                    {
                                                        Yii::$app->session->addFlash('mensaje', [
                                                            'tipo' => 'danger',
                                                            'titulo' => 'FRD Error',
                                                            'icono' => 'far info',
                                                            'mensaje' => 'El código de FRD <b>('.$registro.')</b> no existe o no corrresponde a la competencia del estudiante <b>'.$estudiante->nombre.'</b>.',
                                                        ]);       
                                                    }    
                                                    
                                                }    
                                                    
                                                
                                            }

                                            $i++;

                                        }
                                    }
                                }
                                  

                                if($num_calificaciones_ser > 0)
                                {
                                    $i = 1;
                                    foreach ($calificacion->ser as $c_ser) {
                                        
                                        $ser = Calificacioncalificaciones::find()
                                                ->where(['calificacion_id' => $reg->id])
                                                ->andWhere(['tipo' => 'ser'])
                                                ->andWhere(['docente' => $calificacion->docente])
                                                ->andWhere(['estudiante' => $calificacion->estudiante])
                                                ->andWhere(['grupo' => $calificacion->grupo])
                                                ->andWhere(['asignatura' => $calificacion->asignatura])
                                                ->andWhere(['periodo' => $calificacion->periodo])
                                                ->andWhere(['calificacion_numero' => $i])
                                                ->one();

                                        if($tipo_calificacion == 1)
                                        {
                                            $total = Desempeno::find()->where(['nota' => $c_ser])
                                                    ->andWhere(['tipo_calificacion' => $tipo_calificacion])
                                                    ->count();
                                    
                                            if($total > 0)
                                            {
                                                $ser->calificacion = $c_ser;
                                            }    
                                            else
                                            {
                                                if($c_ser != '')
                                                {

                                                    Yii::$app->session->addFlash('mensaje', [
                                                        'tipo' => 'danger',
                                                        'titulo' => 'Error en la Nota',
                                                        'icono' => 'far info',
                                                        'mensaje' => 'La Nota <b>('.$c_ser.')</b> del estudiante <b>'.$estudiante->nombre.'</b> no exite.',
                                                    ]);    
                                                }
                                            }
                                        }
                                        else
                                        {
                                            $ser->calificacion = $c_ser;
                                        }    
                                        
                                        $ser->update(false);

                                        $i++;

                                    }
                                }

                                ///////////// FIN DE SER ///////////////////


                                /////////////     CALIFICACIONES PSI   ///////////////////

                                if($psi == 1 && $periodo->actual->id != 5)
                                {
                                    $i = 1;
                                    foreach ($calificacion->psi as $c_psi) {
                                            
                                        $r_psi = Calificacioncalificaciones::find()
                                                ->where(['calificacion_id' => $reg->id])
                                                ->andWhere(['tipo' => 'psi'])
                                                ->andWhere(['docente' => $calificacion->docente])
                                                ->andWhere(['estudiante' => $calificacion->estudiante])
                                                ->andWhere(['grupo' => $calificacion->grupo])
                                                ->andWhere(['asignatura' => $calificacion->asignatura])
                                                ->andWhere(['periodo' => $calificacion->periodo])
                                                ->andWhere(['calificacion_numero' => $i])
                                                ->one();

                                        if($tipo_calificacion == 1)
                                        {
                                            $total = Desempeno::find()->where(['nota' => $c_psi])
                                                    ->andWhere(['tipo_calificacion' => $tipo_calificacion])
                                                    ->count();
                                    
                                            if($total > 0)
                                            {
                                                $r_psi->calificacion = $c_psi;
                                            }    
                                            else
                                            {
                                                if($c_psi != '')
                                                {

                                                    Yii::$app->session->addFlash('mensaje', [
                                                        'tipo' => 'danger',
                                                        'titulo' => 'Error en la Nota',
                                                        'icono' => 'far info',
                                                        'mensaje' => 'La Nota <b>('.$c_psi.')</b> del estudiante <b>'.$estudiante->nombre.'</b> no exite.',
                                                    ]);    
                                                }
                                            }
                                        }
                                        else
                                        {
                                            $r_psi->calificacion = $c_psi;
                                        }    
                                        
                                        $r_psi->update(false);

                                        $i++;

                                    }
                                
                                }

                                ///////////// FIN DE PSI ///////////////////    
                                $transaction->commit();

                                Yii::$app->session->addFlash('mensaje', [
                                    'tipo' => 'info',
                                    'titulo' => 'Calificaciones Actualizadas',
                                    'icono' => 'fa info',
                                    'mensaje' => 'Las calificaciones de <b>'.$estudiante->nombre.'</b> se actualizaron correctamente.',
                                ]); 

                            } else {

                                var_dump($model->errors);

                                $transaction->rollBack();
                            }


                        } catch (Exception $e) {
                    $transaction->rollBack();
                    }  
                }    
            }

            //////////////////////////////////////////////////////////////////////////////////
            ////////////////                                                  //////////////// 
            ////////////////               PROMEDIOS Y PUESTOS                ////////////////
            ////////////////                                                  ////////////////
            //////////////////////////////////////////////////////////////////////////////////            


            if ($periodo->actual->id != 5)
            {
                $promedio = new Promedio;
                $promedio->getPuestoxGrupo($calificacion->tipo_calificacion, $grupo->grados->id, $grupo->id, $calificacion->asignatura, $calificacion->periodo);
                $promedio->getPromedios($calificacion->tipo_calificacion, $grupo->grados->id, $grupo->id, $calificacion->asignatura, $calificacion->periodo);
            }
            

            return $this->redirect(['docente/index']);
            
        }
        else
        {

            return $this->render('calificaciones', [
                'dataProvider' => $dataProvider,
                'periodo' => $periodo,
                'calificaciones' => $calificaciones,
                'competencias' => $competencias,
                'seleccionmultiple' => $seleccionmultiple,
                'registros' => $registros,
                'grupo' => $grupo,
                'fallas' => $fallas,
                'entrada' => $entrada,
                'frd' => $frd_sede,
                'calificacionxcompetencia' => $calificacionxcompetencia,
                'tipo_calificacion' => $tipo_calificacion,
                'num_competencias' => $num_competencias,
                'num_calificaciones_saber' => $num_calificaciones_saber,
                'num_calificaciones_ser' => $num_calificaciones_ser, 
                'por_calificaciones_saber' => $por_calificaciones_saber,
                'por_calificaciones_ser' => $por_calificaciones_ser,
                'psi' => $psi,
                'num_calificaciones_psi' => $num_calificaciones_psi,
                'por_calificaciones_psi' => $por_calificaciones_psi,
            ]);

        }
    } 

    public function actionNivelaciones()
    {
        $periodo = new Periodo();
        $grupo = Grupo::find()->where(['id' => Yii::$app->request->get('grupo')])->one();
        $asignatura = Asignatura::find()->where(['id' => Yii::$app->request->get('asignatura')])->one(); 
        $psi = $grupo->sedes->psi;
        $entrada = $grupo->sedes->entrada;
        $fallas = $grupo->sedes->fallas;
        $definitiva_psi = 0;

        if($grupo->sedes->autorizar_nivelaciones == 0) {
            throw new NotFoundHttpException('Las nivelaciones están inactivas por el momento.');
        }    

        
        //echo $query->createCommand()->sql;

        //echo $query->createCommand()->getRawSql(); // Mostrar SQL   

        $tipo_calificacion = $grupo->grados->tipo_calificacion;
        $calificacionxcompetencia = $grupo->grados->calificacionxcompetencia;
        $frd_sede = $grupo->sedes->frd;

        $num_competencias = Competencia::find()->where(['asignatura' => Yii::$app->request->get('asignatura')])->andWhere(['periodo' => $periodo->actual->id])->count(); 

        $num_calificaciones_saber = $calificacionxcompetencia == 1 ? $asignatura->num_calificaciones_saber : $num_competencias;
        $num_calificaciones_ser = $asignatura->num_calificaciones_ser;
        $por_calificaciones_saber = $asignatura->por_calificaciones_saber;
        $por_calificaciones_ser = $asignatura->por_calificaciones_ser; 
        $por_calificaciones_psi = $asignatura->por_calificaciones_psi; 
        $num_calificaciones_psi = $grupo->sedes->num_calificaciones_psi;
        
        if($tipo_calificacion == 1) // TIPO CALIFICACION LETRAS
        { 
            $desempeno = explode(",", "S,A,B");

            $query = Calificacion::find()->joinWith(['estudiantes'])
                ->where(['<', 'tercero.estado', 3])
                ->andWhere(['grupo' => Yii::$app->request->get('grupo')])
                ->andWhere(['asignatura' => Yii::$app->request->get('asignatura')])
                ->andWhere(['periodo' => $periodo->actual->id])
                ->andWhere(['NOT IN', 'definitiva_periodo', ["A","S","B"]])
                ->orderBy('tercero.primer_apellido');
        }
        else  // TIPO CALIFICACION NÚMEROS
        {
             $query = Calificacion::find()->joinWith(['estudiantes'])
                ->where(['<', 'tercero.estado', 3])
                ->andWhere(['grupo' => Yii::$app->request->get('grupo')])
                ->andWhere(['asignatura' => Yii::$app->request->get('asignatura')])
                ->andWhere(['periodo' => $periodo->actual->id])
                ->andWhere(['<', 'definitiva_periodo','3'])
                ->orderBy('tercero.primer_apellido');  
        }

        //echo $query->createCommand()->getRawSql(); // Mostrar SQL   


        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'pageSize' => 500,
            ],
        ]);
        
        $registros = Calificacion::find()->where(['grupo' => Yii::$app->request->get('grupo')])->andWhere(['asignatura' => Yii::$app->request->get('asignatura'), 'periodo' => $periodo->actual->id])->count();


        $count = count(Yii::$app->request->post('Calificacion', []));

        if ($num_competencias == 0)
        {
            $error =  '<b>No hay competencias cargadas en la asignatura</b>, debes cargar las competencias primero para poder realizar el cargue de las calificaciones. ';
            $error .= Html::a('<i class="far fa-plus" aria-hidden="true"></i> Agregar Competencias', ['competencia/create', 'grado' => $grupo->grados->id, 'asignatura' => Yii::$app->request->get('asignatura')],['class' => 'btn btn-block btn-success', 'style' => 'margin-top: 20px;']);

            throw new NotFoundHttpException($error);
        } 
        else
        {
            $competencias = Competencia::find()->where(['asignatura' => Yii::$app->request->get('asignatura')])->andWhere(['periodo' => $periodo->actual->id])->all(); 
        } 


        $seleccionmultiple = new Seleccionmultiple();

        if($tipo_calificacion == 1) // TIPO CALIFICACION LETRAS
        { 
            $desempeno = explode(",", "S,A,B");

            $calificaciones = Calificacion::find()->joinWith(['estudiantes'])
                ->where(['<', 'tercero.estado', 3])
                ->andWhere(['grupo' => Yii::$app->request->get('grupo')])
                ->andWhere(['asignatura' => Yii::$app->request->get('asignatura')])
                ->andWhere(['periodo' => $periodo->actual->id])
                ->andWhere(['NOT IN', 'definitiva_periodo', ["A","S","B"]])
                ->orderBy('tercero.primer_apellido')
                ->all();
        }
        else  // TIPO CALIFICACION NÚMEROS
        {
             $calificaciones = Calificacion::find()->joinWith(['estudiantes'])
                ->where(['<', 'tercero.estado', 3])
                ->andWhere(['grupo' => Yii::$app->request->get('grupo')])
                ->andWhere(['asignatura' => Yii::$app->request->get('asignatura')])
                ->andWhere(['periodo' => $periodo->actual->id])
                ->andWhere(['<', 'definitiva_periodo','3'])
                ->orderBy('tercero.primer_apellido')
                ->all();  
        }

        
        if (Model::loadMultiple($calificaciones, Yii::$app->request->post()))  // LA VALIDACION EN EL CONTROLLER DE CALIFICACION Y COEVALUACION GENERA CONFLICTO, SOLO EN LA VISTA LA VALIDACION   
        {
            foreach ($calificaciones as $calificacion) {
                
                $nivelacion = Calificacion::find()->where(['id' => $calificacion->id])->one();
                $nivelacion->nivelacion = $calificacion->nivelacion;
                $nivelacion->definitiva_final_periodo = $calificacion->nivelacion;
                $nivelacion->update();




                Yii::$app->session->addFlash('mensaje', [
                    'tipo' => 'success',
                    'titulo' => 'Nivelaciones Almacenadas',
                    'icono' => 'fa fa-check-square-o',
                    'mensaje' => 'La nivelación de '.$calificacion->estudiantes->nombre.' se almacenó con éxito en el sistema',
                ]);  
            }

            ////////////  PROMEDIOS X GRUPO & GRADO  /////////////
            
            if($tipo_calificacion != 1)
            {
                try {

                    /// PROMEDIO POR GRUPO ///

                    $promedio_grupo = Promedio::find()
                                    ->select(['ROUND(AVG(promedio_estudiante),1) as promedio_estudiante'])
                                    ->where(['grupo' => Yii::$app->request->get('grupo')])
                                    ->andWhere(['periodo' => $periodo->actual->id])
                                    ->groupBy(['grupo'])
                                    ->one();

                    $promedios = Promedio::find()
                                    ->andWhere(['grupo' => Yii::$app->request->get('grupo')])
                                    ->andWhere(['periodo' => $periodo->actual->id])
                                    ->orderBy(['promedio_estudiante' => SORT_DESC])
                                    ->all();

                    $puesto = 0;
                    $promedio_anterior = 0;
                    foreach ($promedios as $promedio) {

                        if($promedio->promedio_estudiante != $promedio_anterior)
                        {
                            $puesto++;
                        }

                        $promedio->puesto_grupo = $puesto;
                        $promedio->promedio_grupo = $promedio_grupo->promedio_estudiante;
                        $promedio_anterior = $promedio->promedio_estudiante;

                        $promedio->update(false);   
                        
                    }

                    /// PROMEDIO POR GRADO ///
                    $grupo = Grupo::find()->where(['id' =>Yii::$app->request->get('grupo')])->one();

                    $promedio_grado = Promedio::find()
                                    ->select(['ROUND(AVG(promedio_estudiante),1) as promedio_estudiante'])
                                    ->where(['grado' => $grupo->grado])
                                    ->andWhere(['periodo' => $periodo->actual->id])
                                    ->groupBy(['grado'])
                                    ->one();

                    $promedios = Promedio::find()
                                    ->where(['grado' => $grupo->grado])
                                    ->andWhere(['periodo' => $periodo->actual->id])
                                    ->orderBy(['promedio_estudiante' => SORT_DESC])
                                    ->all();

                    $puesto = 0;
                    $promedio_anterior = 0;
                    foreach ($promedios as $promedio) {

                        if($promedio->promedio_estudiante != $promedio_anterior)
                        {
                            $puesto++;
                        }

                        $promedio->puesto_grado = $puesto;
                        $promedio->promedio_grado = $promedio_grado->promedio_estudiante;
                        $promedio_anterior = $promedio->promedio_estudiante;

                        $promedio->update(false);   
                        
                    }

                    ////////  PROMEDIOS POR AREAS  ///////////

                    ///  PROMEDIO DEL AREA POR GRUPO  ///

                    $promedio_grupo = Promedioarea::find()
                                    ->select(['ROUND(AVG(promedio_estudiante),1) as promedio_estudiante'])
                                    ->where(['grupo' => $grupo->id])
                                    ->andWhere(['periodo' => $periodo->actual->id])
                                    ->andWhere(['area' => $asignatura->area])
                                    ->groupBy(['grupo'])
                                    ->one();

                    Promedioarea::updateAll(['promedio_grupo' => round($promedio_grupo->promedio_estudiante,1)], ['grupo' => $grupo->id, 'periodo' => $periodo->actual->id, 'area' => $asignatura->area]);

                    /// PROMEDIO DEL AREA POR GRADO ///


                    $suma_grado = Promedioarea::find()
                                    ->select(['ROUND(SUM(DISTINCT promedio_grupo),1) as promedio_grupo'])
                                    ->where(['grado' => $grupo->grado])
                                    ->andWhere(['periodo' => $periodo->actual->id])
                                    ->groupBy(['grado'])
                                    ->one();

                    //echo $suma_grado->createCommand()->getRawSql(); // Mostrar SQL   
                                        
                    $total_grado = (float)$suma_grado->promedio_grupo / count($asignatura->grados->grupos);

                    Promedioarea::updateAll(['promedio_grado' => round($total_grado,1)], ['grado' => $grupo->grado, 'periodo' => $periodo->actual->id]);
                    

                    /// PROMEDIO POR AREA DEL COLEGIO /// 

                    $asignatura = Asignatura::find()->where(['id' =>Yii::$app->request->get('asignatura')])->one();

                    $suma_area = Promedioarea::find()
                                    ->select(['ROUND(SUM(DISTINCT promedio_grado),1) as promedio_grado'])
                                    ->where(['area' => $asignatura->area])
                                    ->andWhere(['periodo' => $periodo->actual->id])
                                    ->groupBy(['area'])
                                    ->one();

                    $total_grados = Asignatura::find()->where(['area' => $asignatura->area])->count();                                   

                    $total_area = (float)$suma_area->promedio_grado / $total_grados;

                    Promedioarea::updateAll(['promedio_area' => round($total_area,1)], ['area' => $asignatura->area, 'periodo' => $periodo->actual->id]);
                    


                } catch (\yii\db\IntegrityException $e) {
                    return $promedio->error_reporting();

                }      
            }

            return $this->redirect(['docente/index']);
        } 
        else
        {
            return $this->render('nivelaciones', [
                'dataProvider' => $dataProvider,
                'periodo' => $periodo,
                'calificaciones' => $calificaciones,
                'competencias' => $competencias,
                'seleccionmultiple' => $seleccionmultiple,
                'registros' => $registros,
                'grupo' => $grupo,
                'fallas' => $fallas,
                'entrada' => $entrada,
                'frd' => $frd_sede,
                'calificacionxcompetencia' => $calificacionxcompetencia,
                'tipo_calificacion' => $tipo_calificacion,
                'num_competencias' => $num_competencias,
                'num_calificaciones_saber' => $num_calificaciones_saber,
                'num_calificaciones_ser' => $num_calificaciones_ser, 
                'por_calificaciones_saber' => $por_calificaciones_saber,
                'por_calificaciones_ser' => $por_calificaciones_ser,
                'psi' => $psi,
                'num_calificaciones_psi' => $num_calificaciones_psi,
                'por_calificaciones_psi' => $por_calificaciones_psi,
            ]);
        }
    } 

    public function actionView($id)
    {
        $model = $this->findModel($id);
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    public function actionCreate()
    {
        $model = new Calificacion();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    public function actionDelete($id)
    {
        //$this->findModel($id)->deleteWithRelated();

        $model = $this->findModel($id);
        $model->eliminado_por = \Yii::$app->user->id;
        $model->eliminado_el = new \yii\db\Expression('NOW()');
        $model->update();

        return $this->redirect(['index']);
    }

    public function actionRestore($id)
    {
        $this->findModel($id)->restoreWithRelated();

        return $this->redirect(['index']);
    }

    public function actionCambiargrupo($tercero, $grupo_new, $grupo_old)
    {
        if(Calificacion::updateAll(['grupo' => $grupo_new], ['grupo' => $grupo_old, 'estudiante' => $tercero]))
        {
            return true;
        }
        else
        {
            return false;
        }    
    }

    protected function findModel($id)
    {
        if (($model = Calificacion::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
